/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy;

public class ModuleId {
    static final String ENCODE_SEPARATOR = ":#@#:";
    private String _organisation;
    private String _name;
    private int _hash;

    public ModuleId(String organisation, String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name not allowed");
        }
        this._organisation = organisation;
        this._name = name;
        this._hash = this._hashCode();
    }

    public String getName() {
        return this._name;
    }

    public String getOrganisation() {
        return this._organisation;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModuleId)) {
            return false;
        }
        ModuleId other = (ModuleId)obj;
        return other._organisation.equals(this._organisation) && other._name.equals(this._name);
    }

    public int hashCode() {
        return this._hash;
    }

    public int _hashCode() {
        int hash = 31;
        hash = hash * 13 + this._organisation.hashCode();
        hash = hash * 13 + this._name.hashCode();
        return hash;
    }

    public String toString() {
        return "[ " + this._organisation + " | " + this._name + " ]";
    }

    public String encodeToString() {
        return this.getOrganisation() + ENCODE_SEPARATOR + this.getName();
    }

    public static ModuleId decode(String encoded) {
        String[] parts = encoded.split(ENCODE_SEPARATOR);
        if (parts.length != 2) {
            throw new IllegalArgumentException("badly encoded module id: '" + encoded + "'");
        }
        return new ModuleId(parts[0], parts[1]);
    }
}

